package com.ejie.ab04b.report;

import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;

/**
 * Agrupa los parametros disponibles con los que se puede configurar el estilo
 * de los excel generados con el componente 'report' de UDA.
 * 
 * Los parametros adquieren sus valores de las clases que estan en el paquete
 * 'org.apache.poi.ss.usermodel'.
 * 
 * @author GFI-NORTE
 */
public class SdfExcelStyle {
	private String fontFamily;// Fuente
	private short fontSize;// Tamanyo
	private short fontBold;// Negrita
	private short fontColorIndexed;// Color de fuente

	private short backgroundColorIndexed;// Color de fondo
	private short alignText;// Alineacion

	// Bordes (anchura y color)
	private short borderTop;
	private short borderBottom;
	private short borderLeft;
	private short borderRight;
	private short borderColor;

	/**
	 * Crea el estilo para un libro excel definido.
	 * 
	 *  workbook
	 *            Libro excel
	 *  CellStyle
	 *
	 * @param workbook the workbook
	 * @return the cell style
	 */
	public CellStyle getCellStyle(Workbook workbook) {
		Font f = workbook.createFont();
		f.setFontName(this.fontFamily);
		f.setFontHeight(this.fontSize);
		f.setBoldweight(this.fontBold);
		f.setColor(this.fontColorIndexed);

		CellStyle s = workbook.createCellStyle();
		s.setFont(f);
		s.setFillForegroundColor(this.backgroundColorIndexed);
		s.setFillPattern(CellStyle.SOLID_FOREGROUND);
		s.setAlignment(this.alignText);
		s.setBorderBottom(this.borderBottom);
		s.setBottomBorderColor(this.borderColor);
		s.setBorderTop(this.borderTop);
		s.setTopBorderColor(this.borderColor);
		s.setBorderLeft(this.borderLeft);
		s.setLeftBorderColor(this.borderColor);
		s.setBorderRight(this.borderRight);
		s.setRightBorderColor(this.borderColor);
		return s;
	}

	/**
	 * Instantiates a new sdf excel style.
	 * 
	 *  fontFamily            String
	 *  fontSize            short
	 *  fontBold            short
	 *  fontColorIndexed            short
	 *  backgroundColorIndexed            short
	 *  alignText            short
	 *
	 * @param fontFamily the font family
	 * @param fontSize the font size
	 * @param fontBold the font bold
	 * @param fontColorIndexed the font color indexed
	 * @param backgroundColorIndexed the background color indexed
	 * @param alignText the align text
	 */
	public SdfExcelStyle(String fontFamily, short fontSize, short fontBold,
			short fontColorIndexed, short backgroundColorIndexed,
			short alignText) {
		this.fontFamily = fontFamily;
		this.fontSize = fontSize;
		this.fontBold = fontBold;
		this.fontColorIndexed = fontColorIndexed;
		this.backgroundColorIndexed = backgroundColorIndexed;
		this.alignText = alignText;
	}

	/**
	 * Instantiates a new sdf excel style.
	 */
	public SdfExcelStyle() {
	}

	/**
	 * Asigna el borde del estilo.
	 * 
	 *  borderTop
	 *            Tipo de anchura del borde
	 *  borderBottom
	 *            Tipo de anchura del borde
	 *  borderLeft
	 *            Tipo de anchura del borde
	 *  borderRight
	 *            Tipo de anchura del borde
	 *  borderColor
	 *            Color del borde
	 *
	 * @param borderTop the border top
	 * @param borderBottom the border bottom
	 * @param borderLeft the border left
	 * @param borderRight the border right
	 * @param borderColor the border color
	 */
	public void setBorder(short borderTop, short borderBottom,
			short borderLeft, short borderRight, short borderColor) {
		this.borderBottom = borderBottom;
		this.borderTop = borderTop;
		this.borderRight = borderRight;
		this.borderLeft = borderLeft;
	}

	/**
	 * Gets the font family.
	 * 
	 *  String
	 *
	 * @return the font family
	 */
	public String getFontFamily() {
		return this.fontFamily;
	}

	/**
	 * Sets the font family.
	 * 
	 *  fontFamily            String
	 *
	 * @param fontFamily the new font family
	 */
	public void setFontFamily(String fontFamily) {
		this.fontFamily = fontFamily;
	}

	/**
	 * Gets the font size.
	 * 
	 *  short
	 *
	 * @return the font size
	 */
	public short getFontSize() {
		return this.fontSize;
	}

	/**
	 * Sets the font size.
	 * 
	 *  fontSize            short
	 *
	 * @param fontSize the new font size
	 */
	public void setFontSize(short fontSize) {
		this.fontSize = fontSize;
	}

	/**
	 * Gets the font bold.
	 * 
	 *  short
	 *
	 * @return the font bold
	 */
	public short getFontBold() {
		return this.fontBold;
	}

	/**
	 * Sets the font bold.
	 * 
	 *  fontBold            short
	 *
	 * @param fontBold the new font bold
	 */
	public void setFontBold(short fontBold) {
		this.fontBold = fontBold;
	}

	/**
	 * Gets the font color indexed.
	 * 
	 *  short
	 *
	 * @return the font color indexed
	 */
	public short getFontColorIndexed() {
		return this.fontColorIndexed;
	}

	/**
	 * Sets the font color indexed.
	 * 
	 *  fontColorIndexed            short
	 *
	 * @param fontColorIndexed the new font color indexed
	 */
	public void setFontColorIndexed(short fontColorIndexed) {
		this.fontColorIndexed = fontColorIndexed;
	}

	/**
	 * Gets the background color indexed.
	 * 
	 *  short
	 *
	 * @return the background color indexed
	 */
	public short getBackgroundColorIndexed() {
		return this.backgroundColorIndexed;
	}

	/**
	 * Sets the background color indexed.
	 * 
	 *  backgroundColorIndexed            short
	 *
	 * @param backgroundColorIndexed the new background color indexed
	 */
	public void setBackgroundColorIndexed(short backgroundColorIndexed) {
		this.backgroundColorIndexed = backgroundColorIndexed;
	}

	/**
	 * Gets the align text.
	 * 
	 *  short
	 *
	 * @return the align text
	 */
	public short getAlignText() {
		return this.alignText;
	}

	/**
	 * Sets the align text.
	 * 
	 *  alignText            short
	 *
	 * @param alignText the new align text
	 */
	public void setAlignText(short alignText) {
		this.alignText = alignText;
	}

	/**
	 * Gets the border top.
	 * 
	 *  short
	 *
	 * @return the border top
	 */
	public short getBorderTop() {
		return this.borderTop;
	}

	/**
	 * Sets the border top.
	 * 
	 *  borderTop            short
	 *
	 * @param borderTop the new border top
	 */
	public void setBorderTop(short borderTop) {
		this.borderTop = borderTop;
	}

	/**
	 * Gets the border bottom.
	 * 
	 *  short
	 *
	 * @return the border bottom
	 */
	public short getBorderBottom() {
		return this.borderBottom;
	}

	/**
	 * Sets the border bottom.
	 * 
	 *  borderBottom            short
	 *
	 * @param borderBottom the new border bottom
	 */
	public void setBorderBottom(short borderBottom) {
		this.borderBottom = borderBottom;
	}

	/**
	 * Gets the border left.
	 * 
	 *  short
	 *
	 * @return the border left
	 */
	public short getBorderLeft() {
		return this.borderLeft;
	}

	/**
	 * Sets the border left.
	 * 
	 *  borderLeft            short
	 *
	 * @param borderLeft the new border left
	 */
	public void setBorderLeft(short borderLeft) {
		this.borderLeft = borderLeft;
	}

	/**
	 * Gets the border right.
	 * 
	 *  short
	 *
	 * @return the border right
	 */
	public short getBorderRight() {
		return this.borderRight;
	}

	/**
	 * Sets the border right.
	 * 
	 *  borderRight            short
	 *
	 * @param borderRight the new border right
	 */
	public void setBorderRight(short borderRight) {
		this.borderRight = borderRight;
	}

	/**
	 * Gets the border color.
	 * 
	 *  short
	 *
	 * @return the border color
	 */
	public short getBorderColor() {
		return this.borderColor;
	}

	/**
	 * Sets the border color.
	 * 
	 *  borderColor            short
	 *
	 * @param borderColor the new border color
	 */
	public void setBorderColor(short borderColor) {
		this.borderColor = borderColor;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override()
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("SgetExcelStyle [fontFamily=");
		builder.append(this.fontFamily);
		builder.append(", fontSize=");
		builder.append(this.fontSize);
		builder.append(", fontBold=");
		builder.append(this.fontBold);
		builder.append(", fontColorIndexed=");
		builder.append(this.fontColorIndexed);
		builder.append(", backgroundColorIndexed=");
		builder.append(this.backgroundColorIndexed);
		builder.append(", alignText=");
		builder.append(this.alignText);
		builder.append(", borderTop=");
		builder.append(this.borderTop);
		builder.append(", borderBottom=");
		builder.append(this.borderBottom);
		builder.append(", borderLeft=");
		builder.append(this.borderLeft);
		builder.append(", borderRight=");
		builder.append(this.borderRight);
		builder.append(", borderColor=");
		builder.append(this.borderColor);
		builder.append("]");
		return builder.toString();
	}

}
